using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using System.Text;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// FrmEditUnitFinancial
	/// </summary>
	public class FrmEditUnitFinancial : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		/// <summary>
		/// Current working bloodunit
		/// </summary>
		private BOL.BloodUnit _bloodUnit;

		/// <summary>
		/// Is the form data being populated by code?
		/// </summary>
		private bool _isLoading = false;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpFinancial;
		private System.Windows.Forms.Label lblUnitBaseCost;
		private System.Windows.Forms.Label lblSpecialTestCost;
		private System.Windows.Forms.Label lblReturnCredit;
		private System.Windows.Forms.GroupBox grpPicture;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.ToolTip toolTip1;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updBaseCost;
		private System.Windows.Forms.Label label1;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updSpecialTestingCost;
		private System.Windows.Forms.Label label2;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updReturnCredit;
		private System.Windows.Forms.Label label3;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		#endregion

		#region Constructors

		/// <summary>
		/// This form will allow users to modify the financial data associated with a bloodunit
		/// </summary>
		public FrmEditUnitFinancial()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC014EditUnitFinancialData;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this.SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmEditUnitFinancial));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpFinancial = new System.Windows.Forms.GroupBox();
			this.updReturnCredit = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.label3 = new System.Windows.Forms.Label();
			this.updSpecialTestingCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.label2 = new System.Windows.Forms.Label();
			this.updBaseCost = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblReturnCredit = new System.Windows.Forms.Label();
			this.lblSpecialTestCost = new System.Windows.Forms.Label();
			this.lblUnitBaseCost = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.grpPicture = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
			this.grpFinancial.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updSpecialTestingCost)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updBaseCost)).BeginInit();
			this.grpPicture.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(572, 30);
			this.vbecsLogo1.TabIndex = 5;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 364);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(412, 344);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(492, 344);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpFinancial
			// 
			this.grpFinancial.AccessibleDescription = "Financial Information";
			this.grpFinancial.AccessibleName = "Financial Information";
			this.grpFinancial.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpFinancial.Controls.Add(this.updReturnCredit);
			this.grpFinancial.Controls.Add(this.label3);
			this.grpFinancial.Controls.Add(this.updSpecialTestingCost);
			this.grpFinancial.Controls.Add(this.label2);
			this.grpFinancial.Controls.Add(this.updBaseCost);
			this.grpFinancial.Controls.Add(this.lblReturnCredit);
			this.grpFinancial.Controls.Add(this.lblSpecialTestCost);
			this.grpFinancial.Controls.Add(this.lblUnitBaseCost);
			this.grpFinancial.Controls.Add(this.label1);
			this.grpFinancial.Enabled = false;
			this.grpFinancial.Location = new System.Drawing.Point(320, 248);
			this.grpFinancial.Name = "grpFinancial";
			this.grpFinancial.Size = new System.Drawing.Size(248, 92);
			this.grpFinancial.TabIndex = 2;
			this.grpFinancial.TabStop = false;
			this.grpFinancial.Text = "Financial Information";
			// 
			// updReturnCredit
			// 
			this.updReturnCredit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updReturnCredit.DecimalPlaces = 2;
			this.updReturnCredit.Location = new System.Drawing.Point(136, 64);
			this.updReturnCredit.Maximum = new System.Decimal(new int[] {
																			999,
																			0,
																			0,
																			0});
			this.updReturnCredit.Name = "updReturnCredit";
			this.updReturnCredit.Size = new System.Drawing.Size(96, 20);
			this.updReturnCredit.TabIndex = 8;
			this.updReturnCredit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updReturnCredit.Value = new System.Decimal(new int[] {
																		  0,
																		  0,
																		  0,
																		  0});
			this.updReturnCredit.TextChanged += new System.EventHandler(this.SetReturnCreditCost);
			this.updReturnCredit.Leave += new System.EventHandler(this.ReturnCreditCostLeave);
			this.updReturnCredit.ValueChanged += new System.EventHandler(this.SetReturnCreditCost);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(128, 64);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(18, 20);
			this.label3.TabIndex = 7;
			this.label3.Text = "$";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updSpecialTestingCost
			// 
			this.updSpecialTestingCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updSpecialTestingCost.DecimalPlaces = 2;
			this.updSpecialTestingCost.Location = new System.Drawing.Point(136, 40);
			this.updSpecialTestingCost.Maximum = new System.Decimal(new int[] {
																				  999,
																				  0,
																				  0,
																				  0});
			this.updSpecialTestingCost.Name = "updSpecialTestingCost";
			this.updSpecialTestingCost.Size = new System.Drawing.Size(96, 20);
			this.updSpecialTestingCost.TabIndex = 5;
			this.updSpecialTestingCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updSpecialTestingCost.Value = new System.Decimal(new int[] {
																				0,
																				0,
																				0,
																				0});
			this.updSpecialTestingCost.TextChanged += new System.EventHandler(this.SetSpecialTestingCost);
			this.updSpecialTestingCost.Leave += new System.EventHandler(this.SpecialTestingCostLeave);
			this.updSpecialTestingCost.ValueChanged += new System.EventHandler(this.SetSpecialTestingCost);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(128, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(18, 20);
			this.label2.TabIndex = 4;
			this.label2.Text = "$";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updBaseCost
			// 
			this.updBaseCost.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updBaseCost.DecimalPlaces = 2;
			this.updBaseCost.Location = new System.Drawing.Point(136, 16);
			this.updBaseCost.Maximum = new System.Decimal(new int[] {
																		999999,
																		0,
																		0,
																		0});
			this.updBaseCost.Name = "updBaseCost";
			this.updBaseCost.Size = new System.Drawing.Size(96, 20);
			this.updBaseCost.TabIndex = 2;
			this.updBaseCost.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updBaseCost.Value = new System.Decimal(new int[] {
																	  0,
																	  0,
																	  0,
																	  0});
			this.updBaseCost.TextChanged += new System.EventHandler(this.SetBaseCost);
			this.updBaseCost.Leave += new System.EventHandler(this.BaseCostLeave);
			this.updBaseCost.ValueChanged += new System.EventHandler(this.SetBaseCost);
			// 
			// lblReturnCredit
			// 
			this.lblReturnCredit.Location = new System.Drawing.Point(8, 64);
			this.lblReturnCredit.Name = "lblReturnCredit";
			this.lblReturnCredit.Size = new System.Drawing.Size(100, 20);
			this.lblReturnCredit.TabIndex = 6;
			this.lblReturnCredit.Text = "Return Credit";
			this.lblReturnCredit.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblSpecialTestCost
			// 
			this.lblSpecialTestCost.Location = new System.Drawing.Point(8, 40);
			this.lblSpecialTestCost.Name = "lblSpecialTestCost";
			this.lblSpecialTestCost.Size = new System.Drawing.Size(100, 20);
			this.lblSpecialTestCost.TabIndex = 3;
			this.lblSpecialTestCost.Text = "Special Test Cost";
			this.lblSpecialTestCost.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitBaseCost
			// 
			this.lblUnitBaseCost.Location = new System.Drawing.Point(8, 16);
			this.lblUnitBaseCost.Name = "lblUnitBaseCost";
			this.lblUnitBaseCost.Size = new System.Drawing.Size(92, 20);
			this.lblUnitBaseCost.TabIndex = 0;
			this.lblUnitBaseCost.Text = "Base Cost";
			this.lblUnitBaseCost.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(128, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(18, 20);
			this.label1.TabIndex = 1;
			this.label1.Text = "$";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpPicture
			// 
			this.grpPicture.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpPicture.Controls.Add(this.pictureBox1);
			this.grpPicture.Location = new System.Drawing.Point(4, 36);
			this.grpPicture.Name = "grpPicture";
			this.grpPicture.Size = new System.Drawing.Size(52, 304);
			this.grpPicture.TabIndex = 6;
			this.grpPicture.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 36);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 304);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelector1_SearchClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelector1_UnitUpdate);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelector1_ClearBtnClick);
			// 
			// bloodUnitDetailsTab1
			// 
			this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitDetailsTab1.BloodUnit = null;
			this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(320, 40);
			this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
			this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(248, 204);
			this.bloodUnitDetailsTab1.TabIndex = 1;
			// 
			// FrmEditUnitFinancial
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(572, 380);
			this.Controls.Add(this.bloodUnitSelectorVertical1);
			this.Controls.Add(this.grpFinancial);
			this.Controls.Add(this.grpPicture);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.bloodUnitDetailsTab1);
			this.hlphelpChm.SetHelpKeyword(this, "Edit_Financial_Data.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(580, 407);
			this.Name = "FrmEditUnitFinancial";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Edit Unit Financial Data";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmEditUnitFinancial_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.bloodUnitDetailsTab1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpPicture, 0);
			this.Controls.SetChildIndex(this.grpFinancial, 0);
			this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpFinancial.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updReturnCredit)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updSpecialTestingCost)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updBaseCost)).EndInit();
			this.grpPicture.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events

		/// <summary>
		/// When the unit enters a valid product code and unit id
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_UnitUpdate(object sender, System.EventArgs e)
		{
			try
			{
				bool success = this.GetBloodUnit();
				this.SetControlData(success);
				this.SetControlState(success);
				this.bloodUnitDetailsTab1.BloodUnit = (success) ? this.bloodUnitSelectorVertical1.SelectedBloodUnit : null;
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			}
			catch(Exception err)
			{
				this.bloodUnitDetailsTab1.BloodUnit = null;
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
				this.SetControlData(false);
				this.SetControlState(false);
			}
		}

		/// <summary>
		/// When the user clicks the search button on the blood unit selector
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();

					//Get a list of valid units for this division to prepopulate UC5
					DataTable eligDt = BOL.BloodUnitFinance.GetFinancialBloodUnits();
					
					//Create a new dialog window and set the required properties...
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Unit for Financial Editing";
					unitSelector.LogoBarText = "Select Unit for Financial Editing";
					unitSelector.ShowDialogFromLockedParent(this, false);
					
					//If everything went ok, we'll just grab the top row and populate our little BloodUnitSelector
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						DataRow dr = unitSelector.SelectedUnits.Rows[0];
//						this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), 
//																		dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
						this.bloodUnitSelectorVertical1.DisplayBloodUnit(new BOL.BloodUnit((Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid]));
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
				}
			}
		}

		/// <summary>
		/// This clears the UnitId and productCode fields
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelector1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.SetControlData(false);
			this.SetControlState(false);
			this.UnlockAllRecords();
			this.bloodUnitDetailsTab1.BloodUnit = null;
			//Resetting everything on the page including the dirty value
			this.IsDirty=false;
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, string.Empty); // **** 508 Compliance ***
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(String.Empty);
		}

		/// <summary>
		/// Set the Special Testing cost
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SetSpecialTestingCost(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._bloodUnit != null)
					{
						try
						{
							this._bloodUnit.BloodUnitFinance.SpecialTestingCost = this.updSpecialTestingCost.Value;
							this.errError.SetVbecsError(this.updSpecialTestingCost, String.Empty); // **** 508 Compliance ***
						}
						catch(FormatException)
						{
							this._bloodUnit.BloodUnitFinance.SpecialTestingCost = decimal.MinusOne;
						}
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updSpecialTestingCost, err.Message); // **** 508 Compliance ***
			}
		}

		private void SpecialTestingCostLeave(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						this._bloodUnit.BloodUnitFinance.SpecialTestingCost = this.updSpecialTestingCost.Value;
						this.errError.SetVbecsError(this.updSpecialTestingCost, String.Empty); // **** 508 Compliance ***
					}
					catch(FormatException err)
					{
						this._bloodUnit.BloodUnitFinance.SpecialTestingCost = decimal.MinusOne;
						this.errError.SetVbecsError(this.updSpecialTestingCost, err.Message); // **** 508 Compliance ***
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updSpecialTestingCost, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Set the Unit Base Cost
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SetBaseCost(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._bloodUnit != null)
					{
						try
						{
							this._bloodUnit.BloodUnitFinance.UnitCost = this.updBaseCost.Value;
							this.errError.SetVbecsError(this.updBaseCost, String.Empty); // **** 508 Compliance ***
						}
						catch(FormatException)
						{
							this._bloodUnit.BloodUnitFinance.UnitCost = decimal.MinusOne;
						}
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updBaseCost, err.Message); // **** 508 Compliance ***
			}
		}

		private void BaseCostLeave(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						this._bloodUnit.BloodUnitFinance.UnitCost = this.updBaseCost.Value;
						this.errError.SetVbecsError(this.updBaseCost, String.Empty); // **** 508 Compliance ***
					}
					catch(FormatException err)
					{
						this._bloodUnit.BloodUnitFinance.UnitCost = decimal.MinusOne;
						this.errError.SetVbecsError(this.updBaseCost, err.Message); // **** 508 Compliance ***
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updBaseCost, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Set the ReturnCredit value
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SetReturnCreditCost(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._bloodUnit != null)
					{
						try
						{
							this._bloodUnit.BloodUnitFinance.ReturnCreditAmount =  this.updReturnCredit.Value;
							this.errError.SetVbecsError(this.updReturnCredit, String.Empty); // **** 508 Compliance ***
						}
						catch(FormatException)
						{
							this._bloodUnit.BloodUnitFinance.ReturnCreditAmount = decimal.MinusOne;
						}
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updReturnCredit, err.Message); // **** 508 Compliance ***
			}
		}

		private void ReturnCreditCostLeave(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					try
					{
						this._bloodUnit.BloodUnitFinance.ReturnCreditAmount = this.updReturnCredit.Value;
						this.errError.SetVbecsError(this.updReturnCredit, String.Empty); // **** 508 Compliance ***
					}
					catch(FormatException err)
					{
						this._bloodUnit.BloodUnitFinance.ReturnCreditAmount = decimal.MinusOne;
						this.errError.SetVbecsError(this.updReturnCredit, err.Message); // **** 508 Compliance ***
					}
				}
			}
			catch (BOL.BrokenRuleException err)
			{
				this.errError.SetVbecsError(this.updReturnCredit, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// Event attached to the Valid/Invalid/IsDirtyChanged events of the BloodUnitFinance object
		/// Enables the OK button if the user is valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			if (this._bloodUnit != null)
			{
				if (this._bloodUnit.BloodUnitFinance.IsValid)
				{
					if (this.IsDirty)
					{
						btnOK.EnabledButton = true;
						btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
						return;
					}
				}
				else
				{
					btnOK.EnabledButton = false;
					btnOK.SetToolTip(this._bloodUnit.BloodUnitFinance.GetBrokenRulesMessage(this.Name));
					return;
				}
			}

			btnOK.EnabledButton = false;
			btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
		}


		/// <summary>
		/// When the user clicks the 'Cancel' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// When the user clicks the 'OK' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("blood unit financial"));
			
			if (saveResult == DialogResult.Yes)
			{
				try
				{
					if (this._bloodUnit.BloodUnitFinance.Save(Common.UpdateFunction.UC014FrmEditUnitFinancial))
					{
						this.bloodUnitSelector1_ClearBtnClick(sender,e);
						this.bloodUnitSelectorVertical1.DisplayBloodUnit(string.Empty, string.Empty);
						this.SetControlData(false);
						this.SetControlState(false);

						//Set focus so they can go another round
						this.bloodUnitSelectorVertical1.txtUnitID.Focus();
						this.btnOK.EnabledButton = false;
						this.btnOK.SetToolTip(String.Empty);
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Blood unit finance"));
					}
				}
				catch(RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmEditUnitFinancial_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton && this._bloodUnit == null )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.SelectBloodUnit().ResString;
			}	
			else if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.bloodUnitSelectorVertical1.GetErrorMessages();
			textToSpeak += "\n" + this.bloodUnitDetailsTab1.GetErrorMessages();
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion

		#region Methods

		/// <summary>
		/// Initializes the form properties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Edit Unit Financial Data";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC014.FrmEditUnitFinancial());

			//Set these values so errors are caught in the business object
			this.updReturnCredit.Minimum = 0;
			this.updReturnCredit.Maximum = BOL.BloodUnitFinance.MaximumReturnCreditAmount;

			this.updBaseCost.Minimum = 0;
			this.updBaseCost.Maximum = BOL.BloodUnitFinance.MaximumBaseCostValue;

			this.updSpecialTestingCost.Minimum = 0;
			this.updSpecialTestingCost.Maximum = BOL.BloodUnitFinance.MaximumSpecialTestCost;

			//Set the tooltips of the controls
			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.toolTip1.SetToolTip(this.updBaseCost, Common.StrRes.Tooltips.UC014.updBaseCost().ResString);
			this.toolTip1.SetToolTip(this.updReturnCredit , Common.StrRes.Tooltips.UC014.updReturnCredit().ResString);
			this.toolTip1.SetToolTip(this.updSpecialTestingCost, Common.StrRes.Tooltips.UC014.updSpecialTestingCost().ResString);
            			
		}


		/// <summary>
		/// Gets a bloodunit based on user input and attaches the events...
		/// </summary>
		private bool GetBloodUnit()
		{

			//Called when a new blood unit is being loaded.
			this.IsDirty=false;

			//Make sure we unlock anything... in case the user grabs a different unit without saving
			this.UnlockAllRecords();

			//Create the new bloodunit 
			this._bloodUnit = new BOL.BloodUnit(this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid);

			//Implent BR_11.04
			if (this._bloodUnit.PendingTransferIndicator)
			{
				//this will raise the problem and be handled?
				throw new BOL.BusinessObjectException(string.Format("Unit {0}, {1} is pending transfer and cannot be selected.",this._bloodUnit.EyeReadableUnitId, this._bloodUnit.FullProductCode));
			}

			if (!this.SetLocks(this._bloodUnit.BloodUnitFinance.BloodUnitFinanceGuid)) return(false);

			_bloodUnit.BloodUnitFinance.SetInitialBrokenRules(this.Name);

			this._bloodUnit.BloodUnitFinance.Invalid += new System.EventHandler(this.OnValid);
			this._bloodUnit.BloodUnitFinance.Valid += new System.EventHandler(this.OnValid);
			this._bloodUnit.BloodUnitFinance.IsDirtyChanged += new System.EventHandler(this.OnValid);
		
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//Everytime a property of the variable is altered and thus the form
			//has been changed in one way or another.
			this._bloodUnit.BloodUnitFinance.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);

			this.IsDirty=false;

			this.OnValid(this, System.EventArgs.Empty);

			return(true);
		}

		/// <summary>
		/// Update the form with/without values from the working _bloodunit object
		/// </summary>
		/// <param name="useObject"></param>
		private void SetControlData(bool useObject)
		{
			this._isLoading = true;

			if (useObject)
			{
				//Set the Base Cost
				if (this._bloodUnit.BloodUnitFinance.IsUnitCostNull)
				{
					this.updBaseCost.Value = 0;
				}
				else
				{
					this.updBaseCost.Value = this._bloodUnit.BloodUnitFinance.UnitCost;
				}

				//Set the Special Test cost
				if (this._bloodUnit.BloodUnitFinance.IsSpecialTestingCostNull)
				{
					this.updSpecialTestingCost.Value = 0;
				}
				else
				{
					this.updSpecialTestingCost.Value = this._bloodUnit.BloodUnitFinance.SpecialTestingCost;
				}

				//Set the ReturnCredit Cost
				if (this._bloodUnit.BloodUnitFinance.IsReturnCreditAmountNull)
				{
					this.updReturnCredit.Value = 0;
				}
				else
				{
					this.updReturnCredit.Value = this._bloodUnit.BloodUnitFinance.ReturnCreditAmount;
				}
			}
			else
			{
				this.updBaseCost.Value = 0;
				this.updSpecialTestingCost.Value = 0;
				this.updReturnCredit.Value = 0;
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Set control state on the form based on boolean being passed in
		/// </summary>
		/// <param name="enabled"></param>
		private void SetControlState(bool enabled)
		{
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = enabled;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = enabled;

			this.grpFinancial.Enabled = enabled;

			if (enabled)
			{
				//Setup the Base Cost...BR_14.02
				this.updBaseCost.Enabled = ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist);

				//Setup the Special Test Cost
				if (this._bloodUnit.BloodUnitFinance.IsSpecialTestingCostNull)
				{
					if (!this._bloodUnit.BloodUnitStatus.IsFinal())	//BR_14.03
					{
						this.updSpecialTestingCost.Enabled = ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.Technologist);
					}
					else
					{
						//Tech's are allowed to enter a new SpecialTesting Cost - we don't need to check roles, since 1 is lowest
						this.updSpecialTestingCost.Enabled = true;		
					}
				}
				else
				{
					this.updSpecialTestingCost.Enabled = ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist);
				}

				//Setup the ReturnCredit Cost
				if (this._bloodUnit.BloodUnitFinance.IsReturnCreditAmountNull)
				{
					this.updReturnCredit.Enabled = false;
				}
				else
				{
					this.updReturnCredit.Enabled = ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist);
				}
			}
		}

	}

		#endregion
}
